
#ifndef RSA_H
#define RSA_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#include "DX_VOS_BaseTypes.h"
#include "CRYS_HASH.h"
#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Feb 20 14:11:42 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version RSA.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */




/************************ Defines ******************************/

/* the modulus size ion bits */
#define RSA_MOD_SIZE_IN_BITS 2048UL
#define RSA_MOD_SIZE_IN_BYTES (RSA_MOD_SIZE_IN_BITS / 8)
#define RSA_MOD_SIZE_IN_WORDS (RSA_MOD_SIZE_IN_BITS / 32)
#define RSA_MOD_SIZE_IN_256BITS (RSA_MOD_SIZE_IN_BITS / 256)
#define RSA_EXP_SIZE_IN_BITS 17UL

/* the exponent */
#define RSA_EXP_VAL          0x00010001UL 

/* RSA PSS verify definitions */ 
#define RSA_PSS_SALT_LENGTH  20
#define RSA_PSS_PAD1_LEN     8

/* The HASH result definition in the VRL */
typedef DxUint32_t HASH_Result_t[CRYS_HASH_SHA256_DIGEST_SIZE_IN_WORDS]; 

/************************ Enums ********************************/


/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/


#ifdef __cplusplus
}
#endif

#endif



